#ifndef GST_IntersectionFileOutput_hpp__
#define GST_IntersectionFileOutput_hpp__

#include "buildspec.h"
#include <GSTenums.h>
#include <string>
#include <vector>

namespace GST
{
namespace ClientUtils
{
GST_API_EXPORT std::string saveZipToDisk(
	const std::vector<unsigned char> &zipData,
	const std::string &outputFilePath);
GST_API_EXPORT std::string saveSvgToDisk(const std::string &input,
										 const std::string &outputFilePath);
GST_API_EXPORT std::string convertSvgAndSaveToDisk(
	const std::string &input,
	const unsigned int dpi,
	const std::string &outputFilePath,
	const GST::ImageType requestedType);
GST_API_EXPORT std::string convertSvgAndSaveToDiskAsTwoPagePdf(
	const std::string &isecInput,
	const std::string legendInput,
	const unsigned int dpi,
	const std::string &outputFilePath);
} // namespace ClientUtils
} // namespace GST
#endif // GST_IntersectionFileOutput_hpp__
